/**
 * Change the course competency settings in a popup.
 *
 * @module     tool_lp/course_competency_settings
 * @copyright  2015 Damyon Wiese <damyon@moodle.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("tool_lp/course_competency_settings",["jquery","core/notification","tool_lp/dialogue","core/str","core/ajax","core/templates","core/pending"],(function($,notification,Dialogue,str,ajax,templates,Pending){var settingsMod=function(selector){$(selector).on("click",this.configureSettings.bind(this))};return settingsMod.prototype._dialogue=null,settingsMod.prototype.configureSettings=function(e){var pendingPromise=new Pending,context={courseid:$(e.target).closest("a").data("courseid"),settings:{pushratingstouserplans:$(e.target).closest("a").data("pushratingstouserplans")}};e.preventDefault(),$.when(str.get_string("configurecoursecompetencysettings","tool_lp"),templates.render("tool_lp/course_competency_settings",context)).then(function(title,templateResult){return this._dialogue=new Dialogue(title,templateResult[0],this.addListeners.bind(this)),this._dialogue}.bind(this)).then(pendingPromise.resolve).catch(notification.exception)},settingsMod.prototype.addListeners=function(){this._find('[data-action="save"]').on("click",this.saveSettings.bind(this)),this._find('[data-action="cancel"]').on("click",this.cancelChanges.bind(this))},settingsMod.prototype.cancelChanges=function(e){e.preventDefault(),this._dialogue.close()},settingsMod.prototype._find=function(selector){return $('[data-region="coursecompetencysettings"]').find(selector)},settingsMod.prototype.saveSettings=function(e){var pendingPromise=new Pending;e.preventDefault();var newValue=this._find('input[name="pushratingstouserplans"]:checked').val(),courseId=this._find('input[name="courseid"]').val(),settings={pushratingstouserplans:newValue};ajax.call([{methodname:"core_competency_update_course_competency_settings",args:{courseid:courseId,settings:settings}}])[0].then(function(){return this.refreshCourseCompetenciesPage()}.bind(this)).then(pendingPromise.resolve).catch(notification.exception)},settingsMod.prototype.refreshCourseCompetenciesPage=function(){var courseId=this._find('input[name="courseid"]').val(),pendingPromise=new Pending;ajax.call([{methodname:"tool_lp_data_for_course_competencies_page",args:{courseid:courseId,moduleid:0}}])[0].then((function(context){return templates.render("tool_lp/course_competencies_page",context)})).then(function(html,js){templates.replaceNode($('[data-region="coursecompetenciespage"]'),html,js),this._dialogue.close()}.bind(this)).then(pendingPromise.resolve).catch(notification.exception)},settingsMod}));

//# sourceMappingURL=course_competency_settings.min.js.map